//
// (c) 2025 wesolutions GmbH
// All rights reserved.
//

import QtQml 2.12
import QtQuick 2.12

import wesual.Ui 1.0

Item {
    id : uiSelectableText

    property string text

    implicitWidth : metrics.boundingRect(text).width
    implicitHeight : input.implicitHeight
    clip : true

    FontMetrics {
        id : metrics

        font : input.font
    }

    TextInput {
        id : input

        anchors.fill : uiSelectableText
        text : activeFocus
               ? uiSelectableText.text
               : metrics.elidedText(
                   uiSelectableText.text,
                   Qt.ElideRight,
                   uiSelectableText.width - 2);
        readOnly : true
        font : UiFonts.getFont(UiFonts.Light, 14)
        color : {
            if (!enabled) {
                return UiColors.getColor(UiColors.MediumLightGrey27);
            } else {
                return UiColors.getColor(UiColors.DarkGrey80);
            }
        }
        selectByMouse : true
        activeFocusOnTab  : false
        selectionColor : UiColors.getColor(UiColors.SelectionGreen)
        selectedTextColor : UiColors.getColor(UiColors.White)
    }

    MouseArea {
        anchors.fill : uiSelectableText

        onPressed : {
            mouse.accepted = false;
            input.forceActiveFocus();
            input.ensureVisible(0);
        }
    }

    Component {
        id : copyHelper

        TextInput {}
    }

    UiContextMenu {
        UiMenuItem {
            text : qsTrId("c111f54b65616b18")
            enabled : uiSelectableText.enabled

            onTriggered : {
                const helper = copyHelper.createObject(
                                 uiSelectableText,
                                 { text : uiSelectableText.text });
                helper.selectAll();
                helper.copy();
                helper.destroy();
            }
        }
    }
}
